'This program sets the Model 2001 to the Model 199 commands as follows
'F2 = Ohms
'R1 = 300 Ohm range
'Z1 = Zero enabled
'P1 = Internal filter enabled, on 300 Ohm range, six readings are averaged
'S1 = 5 1/2 digit resolution
'T5 = One shot trigger on X
'B0 = Reading from A/D converter. This is default on the Model 2001
'G1 = Readings without prefix
'N0 = All channels open
'O1 = Four pole operation
'W150 = 150 millisecond trigger delay
k2001data$ = SPACE$(25)
CALL Initialize(21, 0)          ' init as system controller
'Set up four wire ohms 200  range
   CALL SEND(16, ":SENS:FUNC 'FRES';:SENS:FRES:RANG 200 ", Gpib.status%)
'Set up zero
   CALL SEND(16, ":SENS:FRES:REF:STAT 1", Gpib.status%)
'Set up filter (same as 199 internal filter)
   CALL SEND(16, ":SENS:FRES:AVER:STAT 1;COUN 6", Gpib.status%)
'Set up 5 1/2 digit resolution
   CALL SEND(16, ":SENS:FRES:RES 6", Gpib.status%)
'Set up one shot trigger and 150 millisecond delay
   CALL SEND(16, ":ARM:LAY2:SOUR IMM;COUN 1;DEL .15", Gpib.status%)
'Set up reading without prefix
   CALL SEND(16, ":FORM:ELEM READ", Gpib.status%)
'Set up all channels open
   CALL SEND(16, ":ROUT:OPEN ALL", Gpib.status%)
'Read data
   CALL SEND(16, ":SENS:DATA?", Gpib.status%)
   CALL Enter(k2001data$, Gpib.len%, 16, Gpib.status%)
2001 data$ = LEFT$(k2001data$, Gpib.len%)
   PRINT k2001data$
END


